(*| 21:12  6/02/1990 *)
UNIT EGAWait;

INTERFACE

USES StdTypes,EGAVars;

PROCEDURE WaitKey(Var Key: Char;Var KeyFunc: Keytype);

FUNCTION WaitKeyFunc: KeyType;

PROCEDURE PauseKey;

PROCEDURE PauseRdKey;

FUNCTION Yeskey: Boolean;

IMPLEMENTATION

USES
  KeyBoard;

PROCEDURE WaitKey(Var Key: Char;Var KeyFunc: Keytype);
{Wait for a key to be pressed then read it}
BEGIN
  WHILE NOT KeyReady DO BEGIN
  END;
  GetKey(Key,KeyFunc);
END;  {WaitKey}

FUNCTION WaitKeyFunc: KeyType;
VAR
  K:Char;
  KT:KeyType;
BEGIN
  WaitKey(K,KT);
  WaitKeyFunc:=KT;
END;  {WaitKeyFunc}

PROCEDURE PauseKey;
{Pause until a key is pressed, (key is not read):}
BEGIN
  WHILE NOT KeyReady DO BEGIN;
  END;
END;  {PauseKey}

PROCEDURE PauseRdKey;
{Pause until a key is pressed, (key is read):}
VAR KF: KeyType;
BEGIN
  PauseKey;
  KF:=WaitKeyFunc;
END;  {PauseRdKey}

FUNCTION Yeskey: Boolean;
{Wait for a key to be pressed and return True if key is Y or y (for yes):}
Var key: char; KeyFunc: Keytype;
BEGIN
  WaitKey(Key,KeyFunc);
  YesKey:= (KeyFunc = Normal) AND ((Key='Y') OR (Key='y'));
END;  {YesKey}

END.
